<?php
/*-------------------------------------------------------+
| PHP-Fusion Content Management System
| Copyright © 2002 - 2017 Nick Jones
| http://www.php-fusion.co.uk/
+--------------------------------------------------------+
| Filename: infusion.php
| Version: 1.1
| Author: Virel
| About: Servers status infusion
| Web/Support: https://www.virel.eu/
+--------------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+--------------------------------------------------------*/
if (!defined("IN_FUSION")) { die("Access Denied"); }

include INFUSIONS."virel_servers_status/infusion_db.php";

if (file_exists(INFUSIONS . "virel_servers_status/locale/" . $settings['locale'] . ".php")) {
    include INFUSIONS . "virel_servers_status/locale/" . $settings['locale'] . ".php";
} else {
    include INFUSIONS . "virel_servers_status/locale/Slovak.php";
}

$inf_title = $locale['vss_001'];
$inf_description = $locale['vss_002'];
$inf_version = "1.1";
$inf_developer = "Virel";
$inf_email = "virel@virel.eu";
$inf_weburl = "https://www.virel.eu";

$inf_folder = "virel_servers_status";

$inf_newtables = 3; // Number of new db tables to create or drop.
$inf_insertdbrows = 1; // Numbers rows added into created db tables.
$inf_altertables = 0; // Number of db tables to alter (upgrade).
$inf_deldbrows = 0; // Number of db tables to delete data from.

$inf_newtable[1] = DB_VIREL_S_STATUS." (
							v_status_id INT(12) UNSIGNED NOT NULL AUTO_INCREMENT,
							v_status_ip VARCHAR(45) NOT NULL,
							v_status_port VARCHAR(5) NOT NULL,
							v_status_type TEXT NOT NULL,
							v_status_vote TEXT NOT NULL,
							v_status_order SMALLINT(5) UNSIGNED NOT NULL,
							v_status_vip_url VARCHAR(60) NOT NULL,
							v_status_disabled TINYINT(1) NOT NULL DEFAULT '0',
							PRIMARY KEY (v_status_id)
							) ENGINE=MyISAM;";
							
$inf_newtable[2] = DB_VIREL_S_STATUS_SETT." (
							v_sett_vip TINYINT(1) UNSIGNED DEFAULT '1' NOT NULL,
							v_sett_vote TINYINT(1) UNSIGNED DEFAULT '1' NOT NULL,
							v_sett_percplayer TINYINT(1) UNSIGNED DEFAULT '1' NOT NULL,
							v_sett_map TINYINT(1) UNSIGNED DEFAULT '1' NOT NULL,
							v_sett_show_pl TINYINT(1) UNSIGNED DEFAULT '1' NOT NULL,
							v_sett_vote_time VARCHAR(60) DEFAULT '3600' NOT NULL
							) ENGINE = MyISAM;";
							
$inf_newtable[3] = DB_VIREL_S_STATUS_VOTE." (
							v_vote_id MEDIUMINT(11) NOT NULL AUTO_INCREMENT,
							v_vote_idserv MEDIUMINT(11) NOT NULL,
							v_vote_ip VARCHAR(15) NOT NULL,
							v_vote_date TEXT NOT NULL,
							PRIMARY KEY (v_vote_id)
							) ENGINE = MyISAM;";
							
$inf_insertdbrow[1] = DB_VIREL_S_STATUS_SETT." (v_sett_vip, v_sett_vote, v_sett_percplayer, v_sett_map, v_sett_show_pl, v_sett_vote_time)VALUES('1', '0', '0', '0', '0', '3600')";

$inf_droptable[1] = DB_VIREL_S_STATUS;
$inf_droptable[2] = DB_VIREL_S_STATUS_SETT;
$inf_droptable[3] = DB_VIREL_S_STATUS_VOTE;

$inf_adminpanel[1] = array("title" => $locale['vss_001'], "image" =>
    "images.gif", "panel" => "admin.php", "rights" => "VSS");

$inf_sitelink[1] = array("title" => $locale['vss_003'], "url" =>
    "servers_status.php", "visibility" => "0");
?>