<?php
ini_set('display_errors', 1);
// Load auto loader
require_once(__DIR__ . '/GameQ/Autoloader.php');

// Define the protocols path
$protocols_path = __DIR__ . "/GameQ/Protocols/";

// Grab the dir with all the classes available
$dir = dir($protocols_path);

$protocols = [];

// Now lets loop the directories
while (false !== ($entry = $dir->read())) {
    if (!is_file($protocols_path . $entry)) {
        continue;
    }

    // Lets get some info on the class
    $reflection = new ReflectionClass('\\GameQ\\Protocols\\' . pathinfo($entry, PATHINFO_FILENAME));

    // Check to make sure we can actually load the class
    if (!$reflection->IsInstantiable()) {
        continue;
    }

    // Load up the class so we can get info
    $class = $reflection->newInstance();

    // Add it to the list
    $protocols[ $class->name() ] = [
        'name'  => $class->nameLong(),
    ];

    // Unset the class
    unset($class);
}

// Close the directory
unset($dir);

ksort($protocols);

?>