<?php
/*-------------------------------------------------------+
| PHP-Fusion Content Management System
| Copyright © 2002 - 2017 Nick Jones
| http://www.php-fusion.co.uk/
+--------------------------------------------------------+
| Filename: functions.php
| Version: 1.1
| Author: Virel
| About: Virel Servers Status infusion
| Web/Support: https://www.virel.eu/
+--------------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+--------------------------------------------------------*/
if (!defined("IN_FUSION")) { die("Access Denied"); }

include INFUSIONS."virel_servers_status/infusion_db.php";

if (file_exists(INFUSIONS . "virel_servers_status/locale/" . $settings['locale'] . ".php")) {
    include INFUSIONS . "virel_servers_status/locale/" . $settings['locale'] . ".php";
} else {
    include INFUSIONS . "virel_servers_status/locale/Slovak.php";
}

$vsettings = dbarray(dbquery("SELECT * FROM ".DB_VIREL_S_STATUS_SETT.""));

include "protocols.php";

include_once VSSBASE."includes/GameQ/Autoloader.php";

function icon_type($type) {
	$game = "<img src='".VSIMAGES."icons/games/$type.png' alt='$type'/>"; 
	return $game;
}

function color_players($numplayers,$maxplayers) {
	$players = $numplayers . "/" . $maxplayers;
        if ($numplayers == $maxplayers)
            $players = "<font color='#00FF00'>" . $numplayers . "/" . $maxplayers .
                "</font>";
        if ($numplayers == 0)
            $players = "<font color='red'>" . $numplayers . "/" . $maxplayers .
                "</font>";
	return $players;
}

function percents($num_amount, $num_total) {
 if ($num_amount != 0) {
  $count1 = $num_amount / $num_total;
  $count2 = $count1 * 100;
  $count = number_format($count2, 0);
  return ''.$count.'%';
 } else return '0%';
}

function connect_type($type,$ip,$port) {
	
	global $locale;
	
	if($type == "cs16" || $type=="csgo") {
	$connect = "<a href='steam://connect/$ip:$port' title='".$locale['vss_032']."'><img src='".VSIMAGES."icons/connect_steam.png' alt='steam' border='0' width='12' height='12'/></a>";
	}
	
	if($type == "minecraft") {
	$connect = "<a href='minec://$ip:$port' title='".$locale['vss_032']."'><img src='".VSIMAGES."icons/connect.png' alt='MC' border='0' width='12' height='12'/></a>";
	}
	
	if($type == "samp") {
	$connect = "<a href='samp://$ip:$port' title='".$locale['vss_032']."'><img src='".VSIMAGES."icons/connect.png' alt='SAMP' border='0' width='12' height='12'/></a>";
	}
	
	if($type == "teamspeak3") {
	$connect = "<a href='ts3server://$ip:$port' title='".$locale['vss_033']."'><img src='".VSIMAGES."icons/connect.png' alt='TS3' border='0' width='12' height='12'/></a>";
	} 
	return $connect;
}

function playersTime($time, $units) {
    if ($time >= 86400) {
        return intval($time / 86400) . $units['days'] . playersTime($time % 86400, $units);
    } elseif ($time >= 3600) {
        return intval($time / 3600) . $units['hours'] . playersTime($time % 3600, $units);
    } elseif ($time >= 60) {
        return intval($time / 60) . $units['minutes'] . playersTime($time % 60, $units);
    } else {
        return intval($time) . $units['seconds'];
    }
}

function copy_virel_status() {
	
	echo "<div style='text-align: right; margin-top: 3px;'><a href='https://www.virel.eu/'
	title='Copyright 2017 Virel.eu' target='_blank'>&copy;</a></div>";

 }
 
function copy_virel_status2() {
	
 echo "<div style='text-align: center;'>Created by <a href='https://www.virel.eu/' alt='by Virel' title='by Virel' target='_blank'>Virel</a> &copy; 2017</div>";
 
}
?>