<?php
/*-------------------------------------------------------+
| PHP-Fusion Content Management System
| Copyright  2002 - 2017 Nick Jones
| http://www.php-fusion.co.uk/
+--------------------------------------------------------+
| Filename: infusion.php
| Version: 1.0
| Author: Virel
| About: TeamList infusion
| Web/Support: https://www.virel.eu/
+--------------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+--------------------------------------------------------*/
if (!defined("IN_FUSION")) {
    die("Access Denied");
}

include INFUSIONS . "virel_teamlist/infusion_db.php";

if (file_exists(INFUSIONS . "virel_teamlist/locale/" . $settings['locale'] . ".php")) {
    include INFUSIONS . "virel_teamlist/locale/" . $settings['locale'] . ".php";
} else {
    include INFUSIONS . "virel_teamlist/locale/Slovak.php";
}

$inf_title = $locale['v_tm_001'];
$inf_description = $locale['v_tm_002'];
$inf_version = "1.0";
$inf_developer = "Virel";
$inf_email = "virel@virel.eu";
$inf_weburl = "https://www.virel.eu";

$inf_folder = "virel_teamlist";

$inf_newtables = 2; // Number of new db tables to create or drop.
$inf_insertdbrows = 1; // Numbers rows added into created db tables.
$inf_altertables = 0; // Number of db tables to alter (upgrade).
$inf_deldbrows = 0; // Number of db tables to delete data from.

$inf_newtable[1] = DB_VIREL_TEAMLIST_USERS . " (
							tmu_id INT(12) UNSIGNED NOT NULL AUTO_INCREMENT,
							tmu_userid SMALLINT(5) DEFAULT '1' NOT NULL,
							tmu_hodnost	VARCHAR(50) DEFAULT '' NOT NULL,
							tmu_desc TEXT DEFAULT '' NOT NULL,
							tmu_status SMALLINT(5) DEFAULT '0' NOT NULL,
							tmu_groups SMALLINT(5) DEFAULT '0' NOT NULL,
							tmu_order SMALLINT(5) UNSIGNED NOT NULL,
							PRIMARY KEY (tmu_id)
							) ENGINE=MyISAM;";
							
$inf_newtable[2] = DB_VIREL_TEAMLIST_GROUPS." (
							tmg_id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
							tmg_name VARCHAR(100) DEFAULT 'Group' NOT NULL,
							tmg_pic VARCHAR(50) DEFAULT '' NOT NULL,
							tmg_position SMALLINT(5) DEFAULT '1' NOT NULL,
							tmg_status TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
							PRIMARY KEY (tmg_id)
							) ENGINE = MyISAM;";
							
$inf_droptable[1] = DB_VIREL_TEAMLIST_USERS;
$inf_droptable[2] = DB_VIREL_TEAMLIST_GROUPS;

$inf_adminpanel[1] = array("title" => $locale['v_tm_001'], "image" =>
    "images.gif", "panel" => "admin.php", "rights" => "VTM");

$inf_sitelink[1] = array("title" => $locale['v_tm_003'], "url" =>
    "../../team.php", "visibility" => "0");